//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

/*!
\qmltype     UiSectionHeader
\inqmlmodule we.captivo.Ui
\since       we.captivo.Ui 1.0
\inherits    QtQuick2::Text
\ingroup     captivo-ui-controls

\brief A styled section header element.

The UiSectionHeader component provides a pre-styled text item for use as a
section header of UI control groups.

The following example shows the use of this component:

\qml
import QtQuick 2.4

import wesual.Ui 1.0

UiSectionHeader {
    text : "Lorem ipsum"
}
\endqml
*/


Text {
    id : uiSectionHeader

    font  : UiFonts.getFont(UiFonts.RegularCapitalized, 13)
    color : UiColors.getColor(UiColors.MediumGrey33)
    elide : Text.ElideRight

    states : State {
        name : "disabled"
        when : !uiSectionHeader.enabled

        PropertyChanges {
            target: uiSectionHeader
            color  : UiColors.getColor(UiColors.MediumLightGrey27)
        }
    }
}
